using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;

namespace StrataFlix.Business
{
    public partial class CustomerOrderItemsBO
    {

        #region " Component Implementation "

        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        protected override void Dispose(bool disposing)
        {
            if (disposing && (this.components != null))
            {
                this.components.Dispose();
            }
            base.Dispose(disposing);
        }

        private System.ComponentModel.Container components = null;

        //NOTE: The following procedure is required by the Component Designer
        //It can be modified using the Component Designer.
        //Do not modify it using the code editor.
        [System.Diagnostics.DebuggerNonUserCodeAttribute()]
        private void InitializeComponent()
        {
            //
            //CustomerOrderItemsBO
            //'
        }

        #endregion


        #region BusinessLayer Overriden Methods & Properties

        /// <summary>
        /// The collection of required fields for the business object.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override RequiredFieldsCollection RequiredFields
        {
            get
            {
                return base.RequiredFields;
            }
            set
            {
                base.RequiredFields = value;
            }
        }

        /// <summary>
        /// Defines the constraint that defines the parent-child relationship between this business object type and another business object type.
        /// </summary>
        [Browsable(false), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public override IBusinessParentRelationship ParentRelationship
        {
            get
            {
                return base.ParentRelationship;
            }
            set
            {
                base.ParentRelationship = value;
            }
        }

        /// <summary>
        /// Returns all of the field names in a single string in the form of [field1],[field2],...  This must be used in the place of '*' in select statements if Query Notifications are to be registered.
        /// </summary>
        protected override String AllFieldNames
        {
            get
            {
                return "[coi_pk],[coi_co_pk],[coi_pp_pk],[coi_Qty],[coi_UnitPrice],[coi_TotalPrice],[coi_CreatedAt],[coi_Version]";
            }
        }

        /// <summary>
        /// The name of the database that contains the table to which this business object is mapped.
        /// </summary>
        public override String Database
        {
            get
            {
                return "StrataFlix";
            }
        }

        private static string[] _PrimaryKeyFields = new string[] { "coi_pk" };
        /// <summary>
        /// Gets the field or fields that comprise the primary key for the business object.
        /// </summary>
        public override string[] PrimaryKeyFields
        {
            get
            {
                return _PrimaryKeyFields;
            }
        }

        /// <summary>
        /// The name of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableName
        {
            get
            {
                return "CustomerOrderItems";
            }
        }

        /// <summary>
        /// The schema of the table in the database to which this business object is mapped.
        /// </summary>
        public override String TableSchema
        {
            get
            {
                return "dbo";
            }
        }

        /// <summary>
        /// Creates and returns an array of DataColumns that contains the schema for the table.  This is used to prevent a round trip to the server to aquire the initial schema for the internal DataTable.
        /// </summary>
        protected override DataColumn[] CreateTableSchema()
        {
            return new DataColumn[] {
new DataColumn("coi_pk", typeof(System.Int32)),
new DataColumn("coi_co_pk", typeof(System.Int32)),
new DataColumn("coi_pp_pk", typeof(System.Guid)),
new DataColumn("coi_Qty", typeof(System.Int32)),
new DataColumn("coi_UnitPrice", typeof(System.Decimal)),
new DataColumn("coi_TotalPrice", typeof(System.Decimal)),
new DataColumn("coi_CreatedAt", typeof(System.DateTime)),
new DataColumn("coi_Version", typeof(System.Int32))};
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected void AddBrokenRule(CustomerOrderItemsBOFieldNames Field, string ErrorMessage)
        {
            base.AddBrokenRule(Field, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rule to the business object's collection
        /// </summary>
        protected new void AddBrokenRule(string FieldName, string ErrorMessage)
        {
            base.AddBrokenRule(FieldName, ErrorMessage);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected void AddBrokenRuleByKey(CustomerOrderItemsBOFieldNames Field, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(Field, ErrorMessageKey);
        }

        /// <summary>
        /// Adds a broken rules to the business object's collection using the given message key to pull the error message from the localization database
        /// </summary>
        protected new void AddBrokenRuleByKey(string FieldName, string ErrorMessageKey)
        {
            base.AddBrokenRuleByKey(FieldName, ErrorMessageKey);
        }

        /// <summary>
        /// Gets a collection of the names for all fields that belong to this business object and map to the database.
        /// </summary>
        public override List<string> AllFieldsList
        {
            get
            {
                return _AllFieldsList;
            }
        }

        /// <summary>
        /// Gets a dictionary of the DbTypes for all fields that belong to this business object and map to the database.
        /// </summary>
        public override Dictionary<string, DbType> FieldDbTypes
        {
            get
            {
                return _FieldDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of all fields within this business object that map to the FieldNames enumeration for this business object.
        /// </summary>
        public override BusinessLayerFieldEnumDictionary FieldEnums
        {
            get
            {
                return _FieldEnums;
            }
        }

        /// <summary>
        /// Gets a dictionary of all of the lengths for all fields within this business object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldLengths
        {
            get
            {
                return _FieldLengths;
            }
        }

        /// <summary>
        /// Gets a dictionary of the native DbType (SqlDbType, OracleType, OleDbType, etc.) for all fields within this buisness object that map to a field in the database.
        /// </summary>
        public override Dictionary<string, int> FieldNativeDbTypes
        {
            get
            {
                return _FieldNativeDbTypes;
            }
        }

        /// <summary>
        /// Gets a dictionary of the security permission keys for each field in the business object.
        /// </summary>
        public override Dictionary<string, string> FieldPermissionKeys
        {
            get
            {
                return _FieldPermissionKeys;
            }
        }

        #endregion

        #region Field Properties

        /// <summary>
        /// Primary Key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Primary Key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 coi_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["coi_pk"];
            }
            set
            {
                this.CurrentRow["coi_pk"] = value;
            }
        }

        /// <summary>
        /// Order foreign key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Order foreign key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 coi_co_pk
        {
            get
            {
                return (System.Int32)this.CurrentRow["coi_co_pk"];
            }
            set
            {
                this.CurrentRow["coi_co_pk"] = value;
            }
        }

        /// <summary>
        /// Product foreign key
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Product foreign key"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Guid coi_pp_pk
        {
            get
            {
                return (System.Guid)this.CurrentRow["coi_pp_pk"];
            }
            set
            {
                this.CurrentRow["coi_pp_pk"] = value;
            }
        }

        /// <summary>
        /// Quantity
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Quantity"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 coi_Qty
        {
            get
            {
                return (System.Int32)this.CurrentRow["coi_Qty"];
            }
            set
            {
                this.CurrentRow["coi_Qty"] = value;
            }
        }

        /// <summary>
        /// Unit price
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Unit price"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Decimal coi_UnitPrice
        {
            get
            {
                return (System.Decimal)this.CurrentRow["coi_UnitPrice"];
            }
            set
            {
                this.CurrentRow["coi_UnitPrice"] = value;
            }
        }

        /// <summary>
        /// Total line item price
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Total line item price"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Decimal coi_TotalPrice
        {
            get
            {
                return (System.Decimal)this.CurrentRow["coi_TotalPrice"];
            }
            set
            {
                this.CurrentRow["coi_TotalPrice"] = value;
            }
        }

        /// <summary>
        /// Time Stamp
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Time Stamp"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.DateTime coi_CreatedAt
        {
            get
            {
                return (System.DateTime)this.CurrentRow["coi_CreatedAt"];
            }
            set
            {
                this.CurrentRow["coi_CreatedAt"] = value;
            }
        }

        /// <summary>
        /// Row Version
        /// </summary>
        [Browsable(false),
         BusinessFieldDisplayInEditor(),
         Description("Row Version"),
         DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        public System.Int32 coi_Version
        {
            get
            {
                return (System.Int32)this.CurrentRow["coi_Version"];
            }
            set
            {
                this.CurrentRow["coi_Version"] = value;
            }
        }

        #endregion

        #region Field Property Events

        #endregion

        #region Nested Types & Field Security

        /// <summary>
        /// Contains all of the field names that belong to the business object.
        /// </summary>
        public enum CustomerOrderItemsBOFieldNames
        {
            coi_pk,
            coi_co_pk,
            coi_pp_pk,
            coi_Qty,
            coi_UnitPrice,
            coi_TotalPrice,
            coi_CreatedAt,
            coi_Version,
            CUSTOM_FIELD
        }

        /// <summary>
        /// Gets the System.Type of the enumeration that contains the field names for the business object.
        /// </summary>
        public override System.Type GetFieldEnumType()
        {
            return typeof(CustomerOrderItemsBOFieldNames);
        }

        /// <summary>
        /// Creates a new CheckFieldSecurityEventArgs object that can be used with this business object type.
        /// </summary>
        protected override CheckFieldSecurityEventArgsBase CreateNewFieldSecurityEventArgs(System.Enum Field, string CustomField, string PermissionKey, PermissionInfo Perm)
        {
            return new CheckFieldSecurityEventArgs<CustomerOrderItemsBOFieldNames>(Field, CustomField, PermissionKey, Perm);
        }

        /// <summary>
        /// Describes a method that will handle the CheckFieldScurity event.
        /// </summary>
        public delegate void CheckFieldSecurityEventHandler(object sender, CheckFieldSecurityEventArgs<CustomerOrderItemsBOFieldNames> e);

        /// <summary>
        /// Occurs when the business objects needs to check the security on a field.
        /// </summary>
        public event CheckFieldSecurityEventHandler CheckFieldSecurity;

        /// <summary>
        /// Raises the CheckFieldSecurity event.
        /// </summary>
        protected override void OnCheckFieldSecurity(CheckFieldSecurityEventArgsBase e)
        {
            if (this.CheckFieldSecurity != null)
            {
                this.CheckFieldSecurity(this, (CheckFieldSecurityEventArgs<CustomerOrderItemsBOFieldNames>)e);
            }
        }

        #endregion

        #region Item Property Implementation


        private static List<string> _AllFieldsList;
        private static Dictionary<string, DbType> _FieldDbTypes;
        private static BusinessLayerFieldEnumDictionary _FieldEnums;
        private static Dictionary<string, int> _FieldLengths;
        private static Dictionary<string, int> _FieldNativeDbTypes;
        private static Dictionary<string, string> _FieldPermissionKeys;

        /// <summary>
        /// Initializes the static members of the CustomerOrderItemsBO class.
        /// </summary>
        static CustomerOrderItemsBO()
        {
            //-- Create the new shared dictionary and populate it with an 
            //   instance of each property descriptor
            _PropertyDescriptors = new PropertyDescriptorDictionary(13);
            _PropertyDescriptors.Add("coi_pk", new FieldDescriptor(CustomerOrderItemsBOFieldNames.coi_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("coi_co_pk", new FieldDescriptor(CustomerOrderItemsBOFieldNames.coi_co_pk, typeof(System.Int32)));
            _PropertyDescriptors.Add("coi_pp_pk", new FieldDescriptor(CustomerOrderItemsBOFieldNames.coi_pp_pk, typeof(System.Guid)));
            _PropertyDescriptors.Add("coi_Qty", new FieldDescriptor(CustomerOrderItemsBOFieldNames.coi_Qty, typeof(System.Int32)));
            _PropertyDescriptors.Add("coi_UnitPrice", new FieldDescriptor(CustomerOrderItemsBOFieldNames.coi_UnitPrice, typeof(System.Decimal)));
            _PropertyDescriptors.Add("coi_TotalPrice", new FieldDescriptor(CustomerOrderItemsBOFieldNames.coi_TotalPrice, typeof(System.Decimal)));
            _PropertyDescriptors.Add("coi_CreatedAt", new FieldDescriptor(CustomerOrderItemsBOFieldNames.coi_CreatedAt, typeof(System.DateTime)));
            _PropertyDescriptors.Add("coi_Version", new FieldDescriptor(CustomerOrderItemsBOFieldNames.coi_Version, typeof(System.Int32)));

            _AllFieldsList = new List<string>(8);
            _AllFieldsList.Add("coi_pk");
            _AllFieldsList.Add("coi_co_pk");
            _AllFieldsList.Add("coi_pp_pk");
            _AllFieldsList.Add("coi_Qty");
            _AllFieldsList.Add("coi_UnitPrice");
            _AllFieldsList.Add("coi_TotalPrice");
            _AllFieldsList.Add("coi_CreatedAt");
            _AllFieldsList.Add("coi_Version");

            _FieldDbTypes = new Dictionary<string, DbType>(8);
            _FieldDbTypes.Add("coi_pk", DbType.Int32);
            _FieldDbTypes.Add("coi_co_pk", DbType.Int32);
            _FieldDbTypes.Add("coi_pp_pk", DbType.Guid);
            _FieldDbTypes.Add("coi_Qty", DbType.Int32);
            _FieldDbTypes.Add("coi_UnitPrice", DbType.Currency);
            _FieldDbTypes.Add("coi_TotalPrice", DbType.Currency);
            _FieldDbTypes.Add("coi_CreatedAt", DbType.DateTime);
            _FieldDbTypes.Add("coi_Version", DbType.Int32);

            _FieldEnums = new BusinessLayerFieldEnumDictionary(9);
            _FieldEnums.Add("coi_pk", CustomerOrderItemsBOFieldNames.coi_pk);
            _FieldEnums.Add("coi_co_pk", CustomerOrderItemsBOFieldNames.coi_co_pk);
            _FieldEnums.Add("coi_pp_pk", CustomerOrderItemsBOFieldNames.coi_pp_pk);
            _FieldEnums.Add("coi_Qty", CustomerOrderItemsBOFieldNames.coi_Qty);
            _FieldEnums.Add("coi_UnitPrice", CustomerOrderItemsBOFieldNames.coi_UnitPrice);
            _FieldEnums.Add("coi_TotalPrice", CustomerOrderItemsBOFieldNames.coi_TotalPrice);
            _FieldEnums.Add("coi_CreatedAt", CustomerOrderItemsBOFieldNames.coi_CreatedAt);
            _FieldEnums.Add("coi_Version", CustomerOrderItemsBOFieldNames.coi_Version);
            _FieldEnums.Add("CUSTOM_FIELD", CustomerOrderItemsBOFieldNames.CUSTOM_FIELD);

            _FieldLengths = new Dictionary<string, int>(8);
            _FieldLengths.Add("coi_pk", 4);
            _FieldLengths.Add("coi_co_pk", 4);
            _FieldLengths.Add("coi_pp_pk", 16);
            _FieldLengths.Add("coi_Qty", 4);
            _FieldLengths.Add("coi_UnitPrice", 8);
            _FieldLengths.Add("coi_TotalPrice", 8);
            _FieldLengths.Add("coi_CreatedAt", 8);
            _FieldLengths.Add("coi_Version", 4);

            _FieldNativeDbTypes = new Dictionary<string, int>(8);
            _FieldNativeDbTypes.Add("coi_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("coi_co_pk", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("coi_pp_pk", (int)System.Data.SqlDbType.UniqueIdentifier);
            _FieldNativeDbTypes.Add("coi_Qty", (int)System.Data.SqlDbType.Int);
            _FieldNativeDbTypes.Add("coi_UnitPrice", (int)System.Data.SqlDbType.Money);
            _FieldNativeDbTypes.Add("coi_TotalPrice", (int)System.Data.SqlDbType.Money);
            _FieldNativeDbTypes.Add("coi_CreatedAt", (int)System.Data.SqlDbType.DateTime);
            _FieldNativeDbTypes.Add("coi_Version", (int)System.Data.SqlDbType.Int);

            _FieldPermissionKeys = new Dictionary<string, string>(8);

        }

        private static bool _AreCustomDescriptorsEvaluated = false;
        protected override bool AreCustomDescriptorsEvaluated
        {
            get
            {
                bool llReturn = _AreCustomDescriptorsEvaluated;
                _AreCustomDescriptorsEvaluated = true;
                return llReturn;
            }
        }

        private static PropertyDescriptorDictionary _PropertyDescriptors;
        protected override PropertyDescriptorDictionary PropertyDescriptors
        {
            get
            {
                return _PropertyDescriptors;
            }
        }

        /// <summary>
        /// A PropertyDescriptor class used to Get and Set the value of fields within the CustomerOrderItemsBO business object.
        /// </summary>
        private class FieldDescriptor :
        MicroFour.StrataFrame.Business.FieldPropertyDescriptor<CustomerOrderItemsBOFieldNames>
        {
            public FieldDescriptor(CustomerOrderItemsBOFieldNames field, Type fieldType) :
                base(field, fieldType) { }
            private static Type _ComponentType = typeof(CustomerOrderItemsBO);
            public override object GetValue(object component)
            {
                switch (this.Field)
                {
                    case CustomerOrderItemsBOFieldNames.coi_pk:
                        return ((CustomerOrderItemsBO)component).coi_pk;
                    case CustomerOrderItemsBOFieldNames.coi_co_pk:
                        return ((CustomerOrderItemsBO)component).coi_co_pk;
                    case CustomerOrderItemsBOFieldNames.coi_pp_pk:
                        return ((CustomerOrderItemsBO)component).coi_pp_pk;
                    case CustomerOrderItemsBOFieldNames.coi_Qty:
                        return ((CustomerOrderItemsBO)component).coi_Qty;
                    case CustomerOrderItemsBOFieldNames.coi_UnitPrice:
                        return ((CustomerOrderItemsBO)component).coi_UnitPrice;
                    case CustomerOrderItemsBOFieldNames.coi_TotalPrice:
                        return ((CustomerOrderItemsBO)component).coi_TotalPrice;
                    case CustomerOrderItemsBOFieldNames.coi_CreatedAt:
                        return ((CustomerOrderItemsBO)component).coi_CreatedAt;
                    case CustomerOrderItemsBOFieldNames.coi_Version:
                        return ((CustomerOrderItemsBO)component).coi_Version;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override void SetValue(object component, object value)
            {
                switch (this.Field)
                {
                    case CustomerOrderItemsBOFieldNames.coi_pk:
                        ((CustomerOrderItemsBO)component).coi_pk = (System.Int32)value;
                        break;
                    case CustomerOrderItemsBOFieldNames.coi_co_pk:
                        ((CustomerOrderItemsBO)component).coi_co_pk = (System.Int32)value;
                        break;
                    case CustomerOrderItemsBOFieldNames.coi_pp_pk:
                        ((CustomerOrderItemsBO)component).coi_pp_pk = (System.Guid)value;
                        break;
                    case CustomerOrderItemsBOFieldNames.coi_Qty:
                        ((CustomerOrderItemsBO)component).coi_Qty = (System.Int32)value;
                        break;
                    case CustomerOrderItemsBOFieldNames.coi_UnitPrice:
                        ((CustomerOrderItemsBO)component).coi_UnitPrice = (System.Decimal)value;
                        break;
                    case CustomerOrderItemsBOFieldNames.coi_TotalPrice:
                        ((CustomerOrderItemsBO)component).coi_TotalPrice = (System.Decimal)value;
                        break;
                    case CustomerOrderItemsBOFieldNames.coi_CreatedAt:
                        ((CustomerOrderItemsBO)component).coi_CreatedAt = (System.DateTime)value;
                        break;
                    case CustomerOrderItemsBOFieldNames.coi_Version:
                        ((CustomerOrderItemsBO)component).coi_Version = (System.Int32)value;
                        break;
                    default:
                        throw new BusinessLayerException("Field not supported.");
                }
            }
            public override Type ComponentType
            {
                get
                {
                    return _ComponentType;
                }
            }
        }

        #endregion

    }

}
